package com.amity.socialcloud.sdk.api.chat.channel.create

import com.amity.socialcloud.sdk.model.chat.channel.ChannelCreateOption
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.gson.JsonObject

class AmityConversationChannelCreator {

    class Builder(private val userIds: Set<String>,
        private val displayName: String) {
        private var avatarFileId: String? = null
        private var metadata: JsonObject? = null
        private var tags: AmityTags? = null

        fun avatar(avatar: AmityImage): Builder {
            return apply { this.avatarFileId = avatar.getFileId() }
        }

        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun build(): AmityChannelCreator {
            val option = ChannelCreateOption(
                    displayName = displayName,
                    avatarFileId = avatarFileId,
                    metadata = metadata,
                    tags = tags,
                    userIds = userIds.toList())
            return AmityChannelCreator(AmityChannelCreator.CreationType.CONVERSATION, option)
        }
    }

}