package com.amity.socialcloud.sdk.api.chat.member.query


import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType

enum class AmityChannelMembershipFilter(
    val apiKey: String,
    internal val memberships: List<AmityMembershipType>,
    internal val isMuted: Boolean?
) {
    ALL("all", listOf(AmityMembershipType.MEMBER, AmityMembershipType.BANNED), null),
    MEMBER("member", listOf(AmityMembershipType.MEMBER), null),
    MUTED("muted", ALL.memberships, true),
    BANNED("banned", listOf(AmityMembershipType.BANNED), null);

    companion object {
        fun enumOf(apiKey: String): AmityChannelMembershipFilter {
            return values().find {
                it.apiKey == apiKey
            } ?: ALL
        }
    }

}