package com.amity.socialcloud.sdk.chat.data.marker.message

import com.ekoapp.ekosdk.internal.api.dto.MessageDeliveredUsersQueryDto
import com.ekoapp.ekosdk.internal.api.dto.MessageMarkerQueryDto
import com.ekoapp.ekosdk.internal.api.dto.MessageReadUsersQueryDto
import io.reactivex.rxjava3.core.Single
import retrofit2.http.GET
import retrofit2.http.Path
import retrofit2.http.Query

interface MessageMarkerApi {

    @GET("api/v1/markers/messages")
    fun queryMessageMarkers(
        @Query("messageIds[]") messageIds: List<String>? = null
    ): Single<MessageMarkerQueryDto>
    
    @GET("api/v1/markers/messages/{messageId}/read-users")
    fun queryMessageReadUsers(
        @Path("messageId") messageId: String,
        @Query("memberships[]") memberships: List<String>? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<MessageReadUsersQueryDto>
    
    @GET("api/v1/markers/messages/{messageId}/delivered-users")
    fun queryMessageDeliveredUsers(
            @Path("messageId") messageId: String,
            @Query("memberships[]") memberships: List<String>? = null,
            @Query("options[limit]", encoded = true) limit: Int? = null,
            @Query("options[token]", encoded = true) token: String? = null
    ): Single<MessageDeliveredUsersQueryDto>
    
}