package com.amity.socialcloud.sdk.chat.data.message.preview

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.model.chat.message.AmityMessagePreview
import com.ekoapp.ekosdk.internal.data.model.MessagePreviewEntity
import com.google.gson.JsonObject

internal class MessagePreviewModelMapper : ModelMapper<MessagePreviewEntity, AmityMessagePreview>() {

    override fun map(entity: MessagePreviewEntity): AmityMessagePreview {
        return AmityMessagePreview(
            messagePreviewId = entity.messagePreviewId,
            dataType = getDataType(entity),
            data = getData(entity),
            rawData = entity.data,
            channelId = entity.channelId,
            subChannelId = entity.subChannelId,
            subChannelName = entity.subChannelName ?: "",
            userId = entity.creatorId,
            isDeleted = entity.isDeleted,
            segment = entity.segment,
            createdAt = entity.createdAt,
            updatedAt = entity.updatedAt
        )
    }
    
    private fun getDataType(entity: MessagePreviewEntity): AmityMessage.DataType {
        return AmityMessage.DataType.enumOf(entity.dataType)
    }
    
    private fun getData(entity: MessagePreviewEntity): AmityMessage.Data {
        return AmityMessage.Data.from(
            entity.messagePreviewId,
            getDataType(entity),
            entity.data ?: JsonObject(),
            null,
            null
        )
    }

}