package com.amity.socialcloud.sdk.chat.data.message.preview

import com.amity.socialcloud.sdk.model.chat.message.AmityMessagePreview
import com.ekoapp.ekosdk.internal.data.model.MessagePreviewEntity
import io.reactivex.rxjava3.core.Completable
import org.joda.time.DateTime

internal class MessagePreviewRepository {
	
	fun getMessagePreview(messagePreviewId: String): AmityMessagePreview? {
		return MessagePreviewLocalDataStore().getMessagePreview(messagePreviewId)
				?.let {
					MessagePreviewModelMapper().map(it)
				}
	}
	
	fun getMessagePreviewByChannelId(channelId: String): MessagePreviewEntity? {
		return MessagePreviewLocalDataStore().getMessagePreviewByChannelId(channelId)
	}
	
	fun getMessagePreviewBySubChannelId(subChannelId: String): MessagePreviewEntity? {
		return MessagePreviewLocalDataStore().getMessagePreviewBySubChannelId(subChannelId)
	}
	
	fun saveMessagePreviews(
		messagePreviews: List<MessagePreviewEntity>,
	): Completable {
		return MessagePreviewLocalDataStore().saveMessagePreviews(messagePreviews)
	}
	
	fun saveMessagePreview(
		messagePreview: MessagePreviewEntity,
	): Completable {
		return MessagePreviewLocalDataStore().saveMessagePreview(messagePreview)
	}
	
	fun deleteMessagePreview(messagePreviewId: String) {
		MessagePreviewLocalDataStore().deleteMessagePreview(messagePreviewId)
	}
	
	fun updateSubChannelInfo(subChannelId: String, subChannelName: String, subChannelUpdatedAt: DateTime): Completable {
		return MessagePreviewLocalDataStore().updateSubChannelInfo(subChannelId, subChannelName, subChannelUpdatedAt)
	}
	
	fun clearDeletedMessagePreviews() {
		MessagePreviewLocalDataStore().clearDeletedMessagePreviews()
	}
	
	fun clearAllMessagePreviews() {
		MessagePreviewLocalDataStore().clearAllMessagePreviews()
	}
}