package com.amity.socialcloud.sdk.chat.domain.marker.message

import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerRepository
import com.amity.socialcloud.sdk.chat.data.marker.readuser.MessageReadUsersRequest
import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.ekoapp.ekosdk.internal.api.dto.MessageReadUsersQueryDto
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers

internal class MessageReadUsersComposerUseCase {
	
	fun execute(request: MessageReadUsersRequest): Single<MessageReadUsersQueryDto> {
		return MessageMarkerRepository().fetchMessageReadUsers(request)
			.flatMap { dto ->
				UserRepository().getUserDtoByIds(dto.userIds)
					.map { usersDto ->
						dto.apply {
							users = usersDto
						}
					}
			}.subscribeOn(Schedulers.io())
	}
}