package com.amity.socialcloud.sdk.chat.domain.message

import android.net.Uri
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Completable

class MessageCreateUseCase {

    fun execute(subChannelId: String,
                parentId: String?,
                fileUri: Uri?,
                fileId: String?,
                type: String,
                data: JsonObject,
                tags: AmityTags,
                metadata: JsonObject?,
                mentionees: List<AmityMentioneeTarget>): Completable {
        return MessageRepository().createMessage(
            subChannelId = subChannelId,
            parentId = parentId,
            type = type,
            fileUri = fileUri,
            fileId = fileId,
            data = data,
            tags = tags,
            metadata = metadata,
            mentionees = mentionees
        )
    }

}