package com.amity.socialcloud.sdk.chat.domain.message.preview

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.data.message.preview.MessagePreviewRepository
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository
import com.ekoapp.ekosdk.internal.data.model.MessagePreviewEntity
import io.reactivex.rxjava3.core.Completable

internal class MessagePreviewUpdatedUseCase {
    fun execute(messagePreview: MessagePreviewEntity) : Completable {
        val messagePreviewRepository = MessagePreviewRepository()
        val cachedMessagePreview = messagePreviewRepository.getMessagePreviewBySubChannelId(messagePreview.subChannelId)
        val channelMessagePreview = messagePreviewRepository.getMessagePreviewByChannelId(messagePreview.channelId)
        return if (cachedMessagePreview?.messagePreviewId == messagePreview.messagePreviewId) {
            messagePreviewRepository.saveMessagePreview(messagePreview)
                .andThen {
                    SubChannelRepository().notifyChanges(messagePreview.subChannelId)
                }
                .andThen {
                    if(channelMessagePreview?.messagePreviewId == messagePreview.messagePreviewId) {
                        ChannelRepository().notifyChanges(messagePreview.channelId)
                    }
                }
        } else {
            Completable.complete()
        }
    }

}