package com.amity.socialcloud.sdk.chat.domain.subchannel

import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository
import com.amity.socialcloud.sdk.chat.domain.message.preview.MessagePreviewGetUseCase
import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.model.chat.subchannel.AmitySubChannel

internal class SubChannelComposerUseCase : ComposerUseCase() {

    fun execute(subChannel: AmitySubChannel): AmitySubChannel {
        return subChannel
                .apply(::addUnreadCount)
                .apply(::addMessagePreview)
    }

    private fun addUnreadCount(subChannel: AmitySubChannel): AmitySubChannel {
        return if (CoreClient.isConsistentMode()) {
            val subChannelUnreadInfo = SubChannelMarkerRepository().getSubChannelUnreadInfo(subChannel.getSubChannelId())
            subChannel.apply {
                unreadCount = subChannelUnreadInfo?.calculateUnreadCount() ?: 0
                isMentioned = subChannelUnreadInfo?.calculateIsMentioned() ?: false
                hasMentioned = isMentioned
            }
        } else {
            val subChannelMarker = SubChannelMarkerRepository().getSubChannelMarker(subChannel.getSubChannelId())
            subChannel.apply {
                unreadCount = subChannelMarker?.unreadCount ?: 0
                isMentioned = subChannelMarker?.hasMentioned ?: false
                hasMentioned = isMentioned
            }
        }
    }
    
    private fun addMessagePreview(subChannel: AmitySubChannel): AmitySubChannel {
        return subChannel.apply {
            messagePreview = getMessagePreviewId()?.let { MessagePreviewGetUseCase().execute(it) }
        }
    }

}