package com.amity.socialcloud.sdk.core.data.analytics.paging

import co.amity.rxbridge.toRx2
import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRemoteDataStore
import com.amity.socialcloud.sdk.core.data.user.UserListPersister
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.model.core.analytics.AmityViewedType
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.mediator.QueryStreamMediator
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.Completable
import io.reactivex.Single

internal class ViewedUsersMediator(
    private val viewableItemType: AmityViewedType,
    private val viewableItemId: String
) : QueryStreamMediator<UserEntity, EkoUserListDto>(
    nonce = AmityNonce.ANALYTICS_VIEWED_USERS,
    queryStreamKeyCreator = ViewedUsersKeyCreator(
        viewableItemType = viewableItemType,
        viewableItemId = viewableItemId
    )
) {
    override fun getFirstPageRequest(pageSize: Int): Single<EkoUserListDto> {
        return getRequest(limit = pageSize)
    }

    override fun getFetchByTokenRequest(token: String): Single<EkoUserListDto> {
        return getRequest(token = token)
    }

    override fun persistResponse(dto: EkoUserListDto): Completable {
        return UserListPersister().persist(dto).toRx2()
    }

    override fun convertResponseToQueryToken(dto: EkoUserListDto): QueryStreamQueryToken {
        return QueryStreamQueryToken(
            queryStreamKeyCreator = queryStreamKeyCreator,
            next = dto.token?.next,
            previous = dto.token?.previous,
            primaryKeys = dto.users.map { it.userId }
        )
    }

    private fun getRequest(
        limit: Int? = null,
        token: String? = null
    ): Single<EkoUserListDto> {
        return AnalyticsRemoteDataStore().getReachUsers(
            viewableItemType = viewableItemType,
            viewableItemId = viewableItemId,
            limit = limit,
            token = token
        ).toRx2()
    }
}