package com.amity.socialcloud.sdk.model.core.ad

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.socket.util.EkoGson
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler

@Parcelize
@TypeParceler<JsonObject, JsonObjectParceler>
data class AmityFrequencySettings(
    private val frequency: JsonObject
): Parcelable {
    fun getFeedAdFrequency(): AmityAdFrequency {
        return frequency.get("feed").asJsonObject.let {
            EkoGson.get().fromJson(it, AmityAdFrequency::class.java)
        }
    }

    fun getStoryAdFrequency(): AmityAdFrequency {
        return frequency.get("story").asJsonObject.let {
            EkoGson.get().fromJson(it, AmityAdFrequency::class.java)
        }
    }

    fun getCommentAdFrequency(): AmityAdFrequency {
        return frequency.get("comment").asJsonObject.let {
            EkoGson.get().fromJson(it, AmityAdFrequency::class.java)
        }
    }
}