package com.amity.socialcloud.sdk.model.core.file

enum class AmityFileType(val apiKey: String) {

    FILE("file"),
    IMAGE("image"),
    VIDEO("video"),
    AUDIO("audio");

    companion object {
        fun enumOf(apiKey: String): AmityFileType {
            return values().find { it.apiKey == apiKey } ?: FILE
        }
    }

}