package com.amity.socialcloud.sdk.social.data.comment

import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentAndUserListDto
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.socket.request.CommentCreateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.CommentQueryRequest
import com.ekoapp.ekosdk.internal.api.socket.request.CommentUpdateRequest
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

class CommentRemoteDataStore {

    fun createComment(
        referenceType: String,
        referenceId: String,
        parentId: String?,
        commentId: String?,
        data: JsonObject?,
        attachments: JsonArray?,
        metadata: JsonObject?,
        mentionees: List<AmityMentioneeTarget>?
    ): Single<EkoCommentAndUserListDto> {
        val request = CommentCreateRequest(
            commentId = commentId,
            referenceType = referenceType,
            referenceId = referenceId,
            parentId = parentId,
            data = data,
            attachments = attachments,
            metadata = metadata,
            mentionees = mentionees
        )
        return AmityHttpClient.get(CommentApi::class).flatMap {
            it.createComment(request)
        }
    }

    fun updateComment(
        commentId: String,
        data: JsonObject?,
        attachments: JsonArray?,
        metadata: JsonObject?,
        mentionees: List<AmityMentioneeTarget>?
    ): Single<EkoCommentAndUserListDto> {
        val request = CommentUpdateRequest(commentId, data, attachments, metadata, mentionees)
        return AmityHttpClient.get(CommentApi::class).flatMap {
            it.updateComment(commentId, request)
        }
    }

    fun deleteComment(commentId: String, hardDelete: Boolean): Single<EkoDeletionDto> {
        return AmityHttpClient.get(CommentApi::class).flatMap {
            it.deleteComment(commentId, hardDelete)
        }
    }

    fun queryComments(request: CommentQueryRequest): Single<EkoCommentAndUserListDto> {
        return AmityHttpClient.get(CommentApi::class).flatMap {
            it.queryComments(
                referenceId = request.referenceId,
                referenceType = request.referenceType,
                filterByParentId = request.filterByParentId,
                parentId = request.parentId,
                isDeleted = request.isDeleted,
                sortBy = request.sortBy,
                limit = request.options.limit,
                skip = request.options.skip,
                type = request.options.type,
                token = request.options.token
            )
        }
    }

    fun flagComment(commentId: String): Single<EkoCommentAndUserListDto> {
        return AmityHttpClient.get(CommentApi::class).flatMap {
            it.flagComment(commentId)
        }
    }

    fun unflagComment(commentId: String): Single<EkoCommentAndUserListDto> {
        return AmityHttpClient.get(CommentApi::class).flatMap {
            it.unflagComment(commentId)
        }
    }

    fun isFlaggedByMe(commentId: String): Single<JsonObject> {
        return AmityHttpClient.get(CommentApi::class).flatMap {
            it.isFlaggedByMe(commentId)
        }
    }

    fun getComments(
        request: CommentQueryRequest,
    ): Single<EkoCommentAndUserListDto> {
        return AmityHttpClient.get(CommentApi::class).flatMap {
            it.queryComments(
                referenceId = request.referenceId,
                referenceType = request.referenceType,
                filterByParentId = request.filterByParentId,
                parentId = request.parentId,
                isDeleted = request.isDeleted,
                sortBy = request.sortBy,
                limit = request.options.limit,
                skip = request.options.skip,
                first = request.options.first,
                last = request.options.last,
                type = request.options.type,
                token = request.options.token,
                matchType = request.dataTypes?.matchType,
                dataTypes = request.dataTypes?.values
            )
        }
    }

    fun getCommentByIds(commentIds: List<String>) : Single<EkoCommentAndUserListDto> {
        return AmityHttpClient.get(CommentApi::class).flatMap {
            it.getCommentByIds(commentIds)
        }
    }

}