package com.amity.socialcloud.sdk.social.domain.category.get

import com.amity.socialcloud.sdk.model.social.category.AmityCommunityCategory
import com.amity.socialcloud.sdk.social.data.category.CategoryRepository
import com.amity.socialcloud.sdk.social.domain.category.CategoryComposerUseCase

internal class CategoryGetUseCase {

    fun execute(categoryId: List<String>): List<AmityCommunityCategory> {
        return CategoryRepository().getCategories(categoryId)
            .map { CategoryComposerUseCase().execute(it) }
    }
}