package com.amity.socialcloud.sdk.social.domain.community

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption
import com.amity.socialcloud.sdk.model.social.community.AmityCommunity
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityFilter
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class CommunitySearchUseCase {

    fun execute(
        keyword: String,
        categoryId: String,
        filter: AmityCommunityFilter,
        sortBy: AmityCommunitySortOption,
        isDeleted: Boolean?
    ): Flowable<PagingData<AmityCommunity>> {
        return CommunityRepository().searchCommunityPagingData(
            keyword = keyword,
            categoryId = categoryId,
            filter = filter,
            sortBy = sortBy,
            isDeleted = isDeleted
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { member ->
                CommunityComposerUseCase().execute(member)
            }
        }
    }
}