package com.amity.socialcloud.sdk.video.data.session

import androidx.room.Dao
import androidx.room.Query
import androidx.room.Transaction
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamSessionEntity
import com.amity.socialcloud.sdk.video.data.stream.StreamSessionSyncState
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class EkoStreamSessionDao : EkoObjectDao<EkoStreamSessionEntity>() {
	@Query("SELECT * from stream_session where syncState in (:syncStates) AND watchSeconds > 0 order by startTime DESC")
	abstract fun getAllImpl(syncStates: Array<String>): Flowable<List<EkoStreamSessionEntity>>
	fun getAll(syncStates: Array<String>): Flowable<List<EkoStreamSessionEntity>> {
		return getAllImpl(syncStates)
	}
	
	@Query("SELECT * from stream_session where sessionId = :sessionId")
	abstract fun getByIdImpl(sessionId: String): Flowable<EkoStreamSessionEntity>
	fun getById(sessionId: String): Flowable<EkoStreamSessionEntity> {
		return getByIdImpl(sessionId)
	}
	
	@Query("UPDATE stream_session set syncState = :toState where syncState = :fromState")
	abstract fun updateSyncStateImpl(fromState: String, toState: String)
	@Transaction
	open fun updateSyncState(fromState: StreamSessionSyncState, toState: StreamSessionSyncState) {
		updateSyncStateImpl(fromState.key, toState.key)
	}
	
	@Query("DELETE from stream_session")
	abstract override fun deleteAll()
}