package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject


@Entity(tableName = "social_settings")
class SocialSettingsEntity : EkoObject() {

    internal companion object {
        const val SOCIAL_SETTINGS_ID = "SOCIAL_SETTINGS_ID"
    }

    @PrimaryKey
    var settingId: String = SOCIAL_SETTINGS_ID
    var enabled: Boolean = false
    var allowAllUserToCreateStory: Boolean = false

    override fun getId(): String {
        return settingId
    }
}