package com.ekoapp.ekosdk.internal.api.mapper

import com.ekoapp.ekosdk.internal.EkoFileEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoFileDto
import com.google.gson.JsonElement
import com.google.gson.JsonObject

interface EkoFileMapper : EkoObjectMapper<EkoFileDto, EkoFileEntity> {
	override fun update(objectOnDisk: EkoFileEntity, objectToSave: EkoFileEntity): EkoFileEntity {
		objectOnDisk.fileUrl = objectToSave.fileUrl
		objectOnDisk.type = objectToSave.type
		objectOnDisk.attributes = objectToSave.attributes
		objectOnDisk.createdAt = objectToSave.createdAt
		objectOnDisk.updatedAt = objectToSave.updatedAt
		return objectOnDisk
	}
	
	class AttributesComposer {
		fun compose(dtoAttributes: JsonObject?, status: String?, videoUrl: JsonElement?): JsonObject {
			var attributes = dtoAttributes
			if (attributes == null) {
				attributes = JsonObject()
			}
			if (status != null) {
				attributes.addProperty("status", status)
			}
			if (videoUrl != null && videoUrl.javaClass == JsonObject::class.java) {
				attributes.add("videoUrl", videoUrl)
			}
			return attributes
		}
	}
	
	companion object {
		val MAPPER: EkoFileMapper = object: EkoFileMapper {
			override fun map(dto: EkoFileDto): EkoFileEntity {
				val file = EkoFileEntity()
				file.fileId = dto.fileId!!
				file.fileUrl = dto.fileUrl
				file.type = dto.type
				file.accessType = dto.accessType
				file.createdAt = dto.createdAt
				file.updatedAt = dto.updatedAt
				val attributes = AttributesComposer().compose(dto.attributes, dto.status, dto.videoUrl)
				file.attributes = attributes
				return file
			}
		}
	}
}