package com.ekoapp.ekosdk.internal.api.mapper

import com.amity.socialcloud.sdk.model.core.notification.AmityUserNotificationModule
import com.ekoapp.ekosdk.internal.api.socket.request.NotifiableEventsRequest


internal class EkoNotificationModuleRequestMapper {

    fun map(modules: List<AmityUserNotificationModule.MODIFIER>?): List<NotifiableEventsRequest>? {
        return modules?.map { eventItem ->
            NotifiableEventsRequest(
                    moduleName = eventItem.getModuleName().value,
                    isPushNotifiable = eventItem.isEnabled(),
                    listenFromRoleIds = eventItem.getIncludedRoles() as List<String>?,
                    ignoreFromRoleIds = eventItem.getExcludedRoles() as List<String>?)
        }
    }
}