package com.ekoapp.ekosdk.internal.usecase.user

import com.amity.socialcloud.sdk.core.data.follow.FollowRepository
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowRelationship
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatusFilter
import io.reactivex.rxjava3.core.Flowable

internal class FollowingReactorUseCase {

    fun execute(
        userId: String,
        filter: AmityFollowStatusFilter
    ): Flowable<AmityFollowRelationship> {
        return FollowRepository().getLatestFollowing(
            userId = userId,
            filter = filter
        )
    }
}