package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.UserSubChannelMarkerEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class UserSubChannelMarkerDao : EkoObjectDao<UserSubChannelMarkerEntity>() {
	@Query("SELECT * from user_sub_channel_marker where subChannelId = :subChannelId LIMIT 1")
	abstract fun getById(subChannelId: String): Flowable<UserSubChannelMarkerEntity>
	
	@Query("SELECT * from user_sub_channel_marker where subChannelId = :subChannelId LIMIT 1")
	abstract override fun getByIdNow(subChannelId: String): UserSubChannelMarkerEntity?
	
	@Query("DELETE from user_sub_channel_marker")
	abstract override fun deleteAll()
	
	@Query("DELETE from user_sub_channel_marker where subChannelId = :subChannelId")
	abstract fun deleteById(subChannelId: String)
	
	@Query("UPDATE user_sub_channel_marker set readToSegment = :segment where subChannelId = :subChannelId and readToSegment < :segment")
	abstract fun updateReadToSegment(subChannelId: String, segment: Int)
	
	@Query("DELETE from user_sub_channel_marker where channelId = :channelId")
	abstract fun deleteByChannelId(channelId: String)
}