package com.amity.socialcloud.sdk.api.chat.message.create

import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.model.chat.message.AmityMessageAttachment
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.gson.JsonObject

class AmityAudioMessageCreator internal constructor(
    subChannelId: String,
    parentId: String?,
    tags: AmityTags,
    private val attachment: AmityMessageAttachment,
    private val metadata: JsonObject?,
) : AmityMessageCreator(
    subChannelId = subChannelId,
    parentId = parentId,
    tags = tags,
    attachment = attachment,
    metadata = metadata,
) {

    override fun getDataType(): AmityMessage.DataType {
        return AmityMessage.DataType.AUDIO
    }

    override fun getData(): JsonObject {
        return JsonObject()
    }

    class Builder internal constructor(){

        private lateinit var subChannelId: String
        private var parentId: String? = null
        private var metadata: JsonObject? = null
        private var tags: AmityTags = AmityTags()
        private lateinit var attachment: AmityMessageAttachment

        internal fun subChannelId(subChannelId: String): Builder {
            return apply { this.subChannelId = subChannelId }
        }
    
    
        internal fun attachment(attachment: AmityMessageAttachment): Builder {
            return apply { this.attachment = attachment }
        }

        fun parentId(parentId: String?): Builder {
            return apply { this.parentId = parentId }
        }
    
        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun build(): AmityAudioMessageCreator {
            return AmityAudioMessageCreator(subChannelId, parentId, tags, attachment, metadata)
        }
    }

}