package com.amity.socialcloud.sdk.api.chat.message.latest

import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.ekoapp.ekosdk.internal.usecase.message.GetLatestMessageUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityChannelLatestMessageQuery private constructor(private val channelId: String, private val isDeleted: Boolean?) {

    fun query(): Flowable<AmityMessage> {
        return GetLatestMessageUseCase().execute(channelId, isDeleted)
    }

    class Builder internal constructor(private val channelId: String) {

        private var isDeleted: Boolean? = null

        fun isDeleted(isDeleted: Boolean): Builder {
            this.isDeleted = isDeleted
            return this
        }

        fun build(): AmityChannelLatestMessageQuery {
            return AmityChannelLatestMessageQuery(channelId, isDeleted)
        }
    }
}