package com.amity.socialcloud.sdk.api.social.comment.reaction

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.core.reaction.AmityReaction
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import com.ekoapp.ekosdk.internal.usecase.post.ReactionPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

@Deprecated("Use AmityCoreClient.newReactionRepository().getReactions() instead")
class AmityCommentReactionQuery private constructor(
    private val commentId: String,
    private val reactionName: String
) {

    fun query(): Flowable<PagingData<AmityReaction>> {
        return ReactionPagingDataUseCase().execute(
            referenceType = AmityReactionReferenceType.COMMENT,
            referenceId = commentId,
            reactionName = reactionName
        )
    }

    class Builder internal constructor(private var commentId: String) {

        private var reactionName: String = ""

        fun reactionName(reactionName: String): Builder {
            return apply { this.reactionName = reactionName }
        }

        fun build(): AmityCommentReactionQuery {
            return AmityCommentReactionQuery(commentId, reactionName)
        }
    }

}