package com.amity.socialcloud.sdk.api.social.post.query

import com.amity.socialcloud.sdk.api.core.AmityCoreClient

class AmityPostQueryTarget {

    /**
     * Indicates to make queries from my feed
     * @return new instance of AmityUserPostQuery.Builder.
     */
    fun targetMe(): AmityUserPostQuery.Builder {
        return AmityUserPostQuery.Builder(AmityCoreClient.getUserId())
    }

    /**
     * Indicates to make queries from user feed
     * @param [userId] a userId
     * @return new instance of AmityUserPostQuery.Builder.
     */
    fun targetUser(userId: String): AmityUserPostQuery.Builder {
        return AmityUserPostQuery.Builder(userId)
    }

    /**
     * Indicates to make queries from community feed
     * @param [communityId] a communityId
     * @return new instance of AmityCommunityPostQuery.Builder.
     */
    fun targetCommunity(communityId: String): AmityCommunityPostQuery.Builder {
        return AmityCommunityPostQuery.Builder(communityId)
    }

}