package com.amity.socialcloud.sdk.chat.data.marker.message

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.data.marker.channel.ChannelMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerLocalDataStore
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.UserSubChannelMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.user.UserMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.user.UserMarkerLocalDataStore
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository
import com.amity.socialcloud.sdk.chat.domain.marker.channel.SaveChannelMarkerUseCase
import com.amity.socialcloud.sdk.common.QueryPersister
import com.ekoapp.ekosdk.internal.api.dto.MessageMarkerQueryDto
import io.reactivex.rxjava3.core.Completable

internal class MessageMarkerQueryPersister : QueryPersister<MessageMarkerQueryDto>() {

    override fun persist(dto: MessageMarkerQueryDto): Completable {
        return MessageMarkerLocalDataStore().saveMessageMarkers(MessageMarkerEntityMapper().map(dto.messageMarkers))
            .andThen(SubChannelMarkerLocalDataStore().saveSubChannelMarkers(SubChannelMarkerEntityMapper().map(dto.subChannelMarkers)))
            .andThen(SubChannelMarkerLocalDataStore().saveUserSubChannelMarkers(UserSubChannelMarkerEntityMapper().map(dto.userSubChannelMarkers)))
            .andThen(SaveChannelMarkerUseCase().execute(ChannelMarkerEntityMapper().map(dto.channelMarkers)))
            .andThen(UserMarkerLocalDataStore().saveUserMarkers(UserMarkerEntityMapper().map(dto.userMarkers)))
            .andThen(Completable.fromCallable {
                dto.userSubChannelMarkers
                    .map {  it.subChannelId }
                    .let(SubChannelRepository()::notifySubChannelChanges)
            })
            .andThen(Completable.fromCallable {
                dto.channelMarkers
                    .map { it.channelId }
                    .let(ChannelRepository()::notifyChannelsChanges)
            })
    }

}