package com.amity.socialcloud.sdk.entity.social.story

import androidx.room.Entity
import androidx.room.Ignore
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "storyTarget")
class StoryTargetEntity : EkoObject() {
    @PrimaryKey
    var uniqueId: String = ObjectId.get().toHexString()
    var targetId: String = ObjectId.get().toHexString()
    var targetType: String = "unknown"
    var lastStoryExpiresAt: DateTime? = null
    var lastStorySeenExpiresAt: DateTime? = null
    var targetUpdatedAt: DateTime = DateTime.now()

    // local field
    var hasUnseen: Boolean = false
    var localSortingDate: DateTime? = null
    var localLastStoryExpiresAt: DateTime? = null
    var localLastStorySeenExpiresAt: DateTime? = null

    override fun getId(): String {
        return uniqueId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is StoryTargetEntity
                && Objects.equal(targetId, other.targetId)
                && Objects.equal(targetType, other.targetType)
                && Objects.equal(lastStoryExpiresAt, other.lastStoryExpiresAt)
                && Objects.equal(lastStorySeenExpiresAt, other.lastStorySeenExpiresAt)
                && Objects.equal(targetUpdatedAt, other.targetUpdatedAt)
                && Objects.equal(hasUnseen, other.hasUnseen)
                && Objects.equal(localSortingDate, other.localSortingDate)
                && Objects.equal(localLastStoryExpiresAt, other.localLastStoryExpiresAt)
                && Objects.equal(localLastStorySeenExpiresAt, other.localLastStorySeenExpiresAt)
                )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            targetId,
            targetType,
            lastStoryExpiresAt,
            lastStorySeenExpiresAt,
            targetUpdatedAt,
            hasUnseen,
            localSortingDate,
            localLastStoryExpiresAt,
            localLastStorySeenExpiresAt
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("targetId", targetId)
            add("targetType", targetType)
            add("lastStoryExpiresAt", lastStoryExpiresAt)
            add("lastStorySeenExpiresAt", lastStorySeenExpiresAt)
            add("targetUpdatedAt", targetUpdatedAt)
        }
        return super.internalToString(toStringHelper)
    }

}