package com.amity.socialcloud.sdk.model.core.pin

import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.ekoapp.ekosdk.ReactorObject
import org.joda.time.DateTime

data class AmityPinnedPost(
	val pinId: String,
	val postId: String,
	var post: AmityPost? = null,
	val placement: String,
	val target: AmityPinTarget,
	val pinnedById: String,
	var pinnedBy: AmityUser? = null,
	val pinnedAt: DateTime,
) : ReactorObject {
	enum class PinPlacement(val value: String) {
		DEFAULT("default"),
		ANNOUNCEMENT("announcement"),
		GLOBAL("global"),
	}
	override fun updatedAt(): DateTime {
		return pinnedAt
	}
	
	override fun uniqueId(): String {
		return pinId
	}
}