package com.amity.socialcloud.sdk.social.data.community.paging

import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityMembershipStatusFilter
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator


internal class CommunitySemanticSearchKeyCreator(
    private val query: String,
    private val filter: AmityCommunityMembershipStatusFilter?,
    private val tags: AmityTags?,
    private val categoryIds: List<String>?,
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "query" to query,
            "filter" to (filter ?: "null"),
            "tags" to (tags ?: "null"),
            "categoryIds" to (categoryIds ?: "null"),
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            query = query,
            filter = filter,
            tags = tags,
            categoryIds = categoryIds
        )
    }

    private fun getConditionStatement(
        query: String,
        filter: AmityCommunityMembershipStatusFilter?,
        tags: AmityTags?,
        categoryIds: List<String>?,
    ): String {
        val isDeletedFilterStatement = "community.isDeleted = 0"
        val membershipFilterStatement = when(filter) {
            AmityCommunityMembershipStatusFilter.ALL -> {
                ""
            }
            AmityCommunityMembershipStatusFilter.MEMBER -> {
                " and community.isJoined = 1"
            }
            AmityCommunityMembershipStatusFilter.NOT_MEMBER -> {
                " and community.isJoined = 0"
            }
            else -> ""
        }

        return isDeletedFilterStatement +
                membershipFilterStatement
    }

}