package com.amity.socialcloud.sdk.social.data.storytarget.paging

import com.amity.socialcloud.sdk.api.social.storytarget.AmityGlobalStoryTargetsQueryOption
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator


internal class StoryTargetKeyCreator(
    private val option: AmityGlobalStoryTargetsQueryOption
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "option" to option,
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(option)
    }

    private fun getConditionStatement(
        option: AmityGlobalStoryTargetsQueryOption
    ): String {
        // queryOption filter
        val queryOptionFilterStatement = when (option) {
            AmityGlobalStoryTargetsQueryOption.UNSEEN -> {
                "storyTarget.hasUnseen = 1"
            }
            AmityGlobalStoryTargetsQueryOption.SEEN -> {
                "storyTarget.hasUnseen = 0"
            }
            else -> {
                "storyTarget.targetId is not null"
            }
        }

        val emptyTargetFilter = " and storyTarget.localSortingDate is not null"

        return queryOptionFilterStatement + emptyTargetFilter
    }

}