package com.amity.socialcloud.sdk.social.data.storytarget.singlepage

import com.amity.socialcloud.sdk.dto.social.story.StoryQueryDto
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget
import com.amity.socialcloud.sdk.social.data.story.StoryQueryPersister
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRemoteDataStore
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.mediator.SinglePageMediator
import com.ekoapp.ekosdk.internal.token.DynamicQueryStreamQueryToken
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import org.amity.types.ObjectId


internal class StoryTargetsSinglePageMediator(
    private val targets: List<Pair<AmityStory.TargetType, String>>
) : SinglePageMediator<StoryTargetEntity, StoryQueryDto>(
    nonce = AmityNonce.STORY_TARGET_LIST,
    dynamicQueryStreamKeyCreator = StoryTargetsSinglePageKeyCreator(targets = targets)
) {

    override fun persistResponse(dto: StoryQueryDto): Completable {
        return StoryQueryPersister().persist(dto)
    }

    override fun getRequest(): Single<StoryQueryDto> {
        return StoryTargetRemoteDataStore().getStoryTargets(
            targets = targets,
        )
    }

    override fun convertResponseToQueryToken(dto: StoryQueryDto): DynamicQueryStreamQueryToken {
        return DynamicQueryStreamQueryToken(
            dynamicQueryStreamKeyCreator = dynamicQueryStreamKeyCreator,
            next = null,
            previous = null,
            primaryKeys = dto.storyTargets?.map {
                AmityStoryTarget.generateUniqueId(
                    it.targetType ?: "unknown", it.targetPublicId ?: ObjectId.get().toHexString()
                )
            } ?: emptyList()
        )
    }

}