package com.amity.socialcloud.sdk.video.data.stream

import com.amity.socialcloud.sdk.dto.video.EkoStreamListDto
import com.amity.socialcloud.sdk.dto.video.EkoStreamQueryDto
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.socket.request.CreateStreamRequest
import io.reactivex.rxjava3.core.Single

internal class StreamRemoteDataStore {

    fun createVideoStreaming(request: CreateStreamRequest): Single<EkoStreamListDto> {
        return AmityHttpClient.get(StreamApi::class).flatMap {
            it.createVideoStreaming(request)
        }
    }

    fun disposeVideoStreaming(streamId: String): Single<EkoStreamListDto> {
        return AmityHttpClient.get(StreamApi::class).flatMap {
            it.disposeVideoStreaming(streamId)
        }
    }

    fun getVideoStreaming(streamId: String): Single<EkoStreamListDto> {
        return AmityHttpClient.get(StreamApi::class).flatMap {
            it.getVideoStreaming(streamId)
        }
    }

    fun queryVideoStreaming(
        isLive: Boolean?,
        statuses: List<String>?,
        userPublicIds: List<String>?,
        sortBy: String?,
        isDeleted: Boolean?,
        limit: Int? = null,
        token: String? = null
    ): Single<EkoStreamQueryDto> {
        return AmityHttpClient.get(StreamApi::class).flatMap {
            it.queryVideoStreaming(
                isLive = isLive,
                statuses = statuses,
                userPublicIds = userPublicIds,
                sortBy = sortBy,
                isDeleted = isDeleted,
                limit = limit,
                token = token
            )
        }
    }

}