package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.Nullable;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Transaction;

import com.ekoapp.ekosdk.internal.data.model.EkoBaiduToken;

import io.reactivex.rxjava3.core.Flowable;

@Dao
public abstract class EkoBaiduTokenDao {

    @Query("SELECT * from baidu_token LIMIT 1")
    public abstract Flowable<EkoBaiduToken> getBaiduToken();

    @Query("UPDATE baidu_token set token = :token, userId = :userId, channelId = :channelId")
    public abstract void updateToken(@Nullable String token, @Nullable String userId, @Nullable String channelId);

    @Transaction
    public void insertOrUpdate(EkoBaiduToken baiduToken) {
        if (get() != null) {
            update(baiduToken.getApiKey());
        } else {
            insert(baiduToken);
        }
    }

    @Query("SELECT * from baidu_token LIMIT 1")
    abstract EkoBaiduToken get();

    @Query("UPDATE baidu_token set apiKey = :apiKey")
    abstract void update(String apiKey);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract void insert(EkoBaiduToken baiduToken);
}
