package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import androidx.room.ForeignKey
import com.ekoapp.ekosdk.internal.EkoChannelEntity
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import com.google.common.base.MoreObjects
import com.google.common.base.Objects

@Entity(tableName = "channel_tag",
		primaryKeys = ["channelId", "tagName"],
		foreignKeys = [
			ForeignKey(
				entity = EkoChannelEntity::class,
				parentColumns = ["channelId"],
				childColumns = ["channelId"],
				onDelete = ForeignKey.CASCADE
			)])
class EkoChannelTag constructor(
	val channelId: String,
	val tagName: String
) : EkoTagObject() {
	
	override fun equals(obj: Any?): Boolean {
		if (obj == null) return false
		if (obj === this) return true
		if (obj.javaClass != javaClass) return false
		val other = obj as EkoChannelTag
		return (Objects.equal(channelId, other.channelId)
				&& Objects.equal(tagName, other.tagName))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(
				channelId,
				tagName
		)
	}
	
	override fun toString(): String {
		return MoreObjects.toStringHelper(this)
				.add("channelId", channelId)
				.add("tagName", tagName)
				.toString()
	}
	
	companion object {
		val factory = object : EkoTagFactory<EkoChannelTag> {
			override fun create(id: String, tag: String): EkoChannelTag {
				val channelId = EkoPreconditions.checkValidId(id, "channelId")
				val tagName = EkoPreconditions.checkValidId(tag, "tagName")
				return EkoChannelTag(channelId, tagName)
			}
		}
	}
}