package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.google.common.base.Objects

@Entity(tableName = "fcm_token")
class EkoFcmToken(val token: String) {
	@PrimaryKey
	var id = "SINGLETON_FCM_TOKEN_ID"
	
	override fun equals(obj: Any?): Boolean {
		if (obj == null) return false
		if (obj === this) return true
		if (obj.javaClass != javaClass) return false
		val other = obj as EkoFcmToken
		return (Objects.equal(id, other.id)
				&& Objects.equal(token, other.token))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(id, token)
	}
}