package com.ekoapp.ekosdk.internal.usecase.message

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.amity.socialcloud.sdk.chat.domain.message.MessageComposerUseCase
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuerySortOption
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetMessagePagingDataUseCase {

    fun execute(
        subChannelId: String,
        parentId: String?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        isFilterByParentId: Boolean,
        isDeleted: Boolean?,
        sortOption: AmityMessageQuerySortOption,
        type: AmityMessage.DataType?,
        aroundMessageId: String?,
    ): Flowable<PagingData<AmityMessage>> {

        return MessageRepository().getMessagePagingData(
            subChannelId = subChannelId,
            isFilterByParentId = isFilterByParentId,
            parentId = parentId,
            includingTags = includingTags,
            excludingTags = excludingTags,
            isDeleted = isDeleted,
            sortOption = sortOption,
            type = type,
            aroundMessageId = aroundMessageId
        ).map { pagingData->
            pagingData.map(Executors.newCachedThreadPool()) { message ->
                MessageComposerUseCase().execute(message)
            }
        }
    }

}