package com.ekoapp.ekosdk.internal.usecase.reaction

import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import com.amity.socialcloud.sdk.model.core.reaction.AmityReaction
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import io.reactivex.rxjava3.core.Flowable

class ReactionReactorUseCase {

    fun execute(
        referenceType: AmityReactionReferenceType,
        referenceId: String,
        reactionName: String?
    ): Flowable<AmityReaction> {
        return ReactionRepository().getLatestReaction(
            referenceType = referenceType,
            referenceId = referenceId,
            reactionName = reactionName
        )
    }

}