package com.amity.socialcloud.sdk.api.chat.message.query


import androidx.paging.PagingData
import com.amity.socialcloud.sdk.api.core.ExperimentalAmityApi
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.internal.usecase.message.GetMessagePagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityMessageQuery internal constructor(
    private val subChannelId: String,
    private val sortOption: AmityMessageQuerySortOption,
    private val parentId: String?,
    private val isFilterByParentId: Boolean,
    private var isDeleted: Boolean?,
    private val includingTags: AmityTags,
    private val excludingTags: AmityTags,
    private val type: AmityMessage.DataType?,
    private val aroundMessageId: String?
) {

    class Builder internal constructor(private val subChannelId: String) {
        private var sortOption: AmityMessageQuerySortOption = AmityMessageQuerySortOption.LAST_CREATED
        private var parentId: String? = null
        private var isFilterByParentId: Boolean = false
        private var includingTags: AmityTags = AmityTags()
        private var excludingTags: AmityTags = AmityTags()
        private var isDeleted: Boolean? = null
        private var type: AmityMessage.DataType? = null
        private var aroundMessageId: String? = null

        fun includeDeleted(includeDeleted: Boolean): Builder {
            return apply {
                this.isDeleted = if(includeDeleted) null else false
            }
        }

        fun sortBy(sortOption: AmityMessageQuerySortOption): Builder {
            return apply { this.sortOption = sortOption }
        }

        fun parentId(parentId: String?): Builder {
            return apply {
                this.parentId = parentId
                this.isFilterByParentId = true
            }
        }

        fun includingTags(includingTags: AmityTags): Builder {
            return apply { this.includingTags = includingTags }
        }

        fun excludingTags(excludingTags: AmityTags): Builder {
            return apply { this.excludingTags = excludingTags }
        }
    
        fun type(type: AmityMessage.DataType): Builder {
            return apply { this.type = type }
        }

        fun aroundMessageId(messageId: String?): Builder {
            return apply {
                this.aroundMessageId = messageId
            }
        }

        fun build(): AmityMessageQuery {
            return AmityMessageQuery(
                subChannelId,
                sortOption,
                parentId,
                isFilterByParentId,
                isDeleted,
                includingTags,
                excludingTags,
                type,
                aroundMessageId
            )
        }
    }

    @ExperimentalAmityApi
    fun loader(): AmityMessageLoader {
        return AmityMessageLoader(
            subChannelId,
            sortOption,
            parentId,
            isFilterByParentId,
            isDeleted,
            includingTags,
            excludingTags,
            type
        )
    }

    fun query(): Flowable<PagingData<AmityMessage>> {
        return GetMessagePagingDataUseCase().execute(
            subChannelId,
            parentId,
            includingTags,
            excludingTags,
            isFilterByParentId,
            isDeleted,
            sortOption,
            type,
            aroundMessageId
        )
    }

}