package com.amity.socialcloud.sdk.api.social.comment.create

import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import com.ekoapp.ekosdk.internal.usecase.comment.CreateCommentUseCase
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

abstract class AmityCommentCreator internal constructor(
    val referenceType: String,
    val referenceId: String,
    val parentId: String?,
    val commentId: String?,
    val metadata: JsonObject?,
    internal val mentionees: List<AmityMentioneeTarget>?,
    val dataTypes: List<String>
) {

    abstract fun getData(): JsonObject?

    abstract fun getAttachments(): JsonArray?

    /**
     * Creates a comment
     * @return Async comment as Single<AmityComment>
     */
    fun send(): Single<AmityComment> {
        return CreateCommentUseCase().execute(
            referenceType,
            referenceId,
            parentId,
            commentId,
            getData(),
            dataTypes,
            getAttachments(),
            metadata,
            mentionees
        )
    }

}
