package com.amity.socialcloud.sdk.api.social.post.update

import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.post.AmityPostAttachment
import com.amity.socialcloud.sdk.social.domain.post.update.PostEditUseCase
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Completable


abstract class AmityLegacyPostUpdate internal constructor(
    private val postId: String,
    private val metadata: JsonObject?,
    private val mentionees: List<String>?,
    private val attachments: List<AmityPostAttachment>?
) {
    internal abstract fun getData(): JsonObject

    fun apply(): Completable {
        return PostEditUseCase().execute(postId, getData(), metadata, mentionees, attachments)
    }

    abstract class Builder(private val postId: String) {

        abstract fun text(text: String?): Builder

        abstract fun metadata(metadata: JsonObject): Builder

        abstract fun mentionUsers(userIds: List<String>): Builder

        abstract fun build(): AmityLegacyPostUpdate
    }

}