package com.amity.socialcloud.sdk.api.video.stream.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.video.domain.stream.StreamQueryPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityStreamQuery (private val statuses: Array<AmityStream.Status>) {

    fun query(): Flowable<PagingData<AmityStream>> {
        return StreamQueryPagingDataUseCase().execute(statuses)
    }

    class Builder internal constructor() {

        private var statuses = arrayOf(AmityStream.Status.IDLE)

        fun setStatus(statuses: Array<AmityStream.Status>): Builder {
            this.statuses = statuses
            return this
        }

        fun build(): AmityStreamQuery {
            return AmityStreamQuery(statuses = statuses)
        }
    }
}