package com.amity.socialcloud.sdk.chat.data.marker.readreceipt

import com.ekoapp.ekosdk.internal.SubChannelReadReceiptEntity
import com.ekoapp.ekosdk.internal.ChannelReadReceiptEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable

internal class ReadReceiptLocalDataStore {

    fun getLegacyReadReceipt(subChannelId: String): SubChannelReadReceiptEntity? {
        return UserDatabase.get().subChannelReadReceiptDao().getByIdNow(subChannelId)
    }

    fun saveLegacyReadReceipts(
            readReceipts: List<SubChannelReadReceiptEntity>,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().subChannelReadReceiptDao().save(readReceipts)
        }
    }

    fun updateLegacyLatestSegment(subChannelId: String, segment: Int) {
        UserDatabase.get().subChannelReadReceiptDao().updateLatestSegment(subChannelId, segment)
    }

    fun updateLegacyLatestSyncSegment(subChannelId: String, segment: Int) {
        UserDatabase.get().subChannelReadReceiptDao().updateLatestSyncSegment(subChannelId, segment)
    }

    fun deleteLegacyReadReceipt(subChannelId: String) {
        UserDatabase.get().subChannelReadReceiptDao().deleteBySubChannelId(subChannelId)
    }

    fun getUnsyncLegacyReadReceipt(): List<SubChannelReadReceiptEntity> {
        return UserDatabase.get().subChannelReadReceiptDao().getUnsyncReadReceipts()
    }

    fun getReadReceipt(channelId: String): ChannelReadReceiptEntity? {
        return UserDatabase.get().channelReadReceiptDao().getByIdNow(channelId)
    }

    fun saveReadReceipts(
            readReceipts: List<ChannelReadReceiptEntity>,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().channelReadReceiptDao().save(readReceipts)
        }
    }

    fun updateLatestSegment(channelId: String, segment: Int) {
        UserDatabase.get().channelReadReceiptDao().updateLatestSegment(channelId, segment)
    }

    fun updateLatestSyncSegment(channelId: String, segment: Int) {
        UserDatabase.get().channelReadReceiptDao().updateLatestSyncSegment(channelId, segment)
    }

    fun deleteReadReceipt(channelId: String) {
        UserDatabase.get().channelReadReceiptDao().deleteByChannelId(channelId)
    }

    fun getUnsyncReadReceipt(): List<ChannelReadReceiptEntity> {
        return UserDatabase.get().channelReadReceiptDao().getUnsyncReadReceipts()
    }
}