package com.amity.socialcloud.sdk.chat.data.marker.readuser

import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerLocalDataStore
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerLocalDataStore
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository
import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.user.UserListPersister
import com.ekoapp.ekosdk.internal.api.dto.MessageReadUsersQueryDto
import io.reactivex.rxjava3.core.Completable

internal class MessageReadUsersPersister : QueryPersister<MessageReadUsersQueryDto>() {

    override fun persist(dto: MessageReadUsersQueryDto): Completable {
        return dto.users?.let { UserListPersister().persist(it) } ?: Completable.complete()
                .andThen(MessageMarkerLocalDataStore().saveMessageMarkers(MessageMarkerEntityMapper().map(dto.messageMarkers)))
                .andThen(SubChannelMarkerLocalDataStore().saveSubChannelMarkers(SubChannelMarkerEntityMapper().map(dto.subChannelMarkers)))
                .andThen(Completable.fromCallable {
                    dto.messageMarkers.map { messageMarkerDto ->
                        MessageRepository().updateMarkerHash(messageMarkerDto.messageId,messageMarkerDto.hashCode())
                    }
                })
                .andThen(Completable.fromCallable {
                    dto.subChannelMarkers.map { subChannelMarkerDto ->
                        SubChannelRepository().updateMarkerHash(subChannelMarkerDto.subChannelId,subChannelMarkerDto.hashCode())
                    }
                })
    }

}