package com.amity.socialcloud.sdk.chat.domain.marker.channel

import com.amity.socialcloud.sdk.chat.data.marker.channel.ChannelMarkerRepository

internal class UpdateChannelUnreadLastMentionedSegmentUseCase {

	fun execute(channelId: String, segment: Int) {
		val unread = ChannelMarkerRepository().getChannelUnread(channelId)
		unread?.let {
			if ((unread.lastMentionedSegment ?: 0) < segment) {
				unread.lastMentionedSegment = segment
				ChannelMarkerRepository().saveChannelUnread(listOf(unread))
			}
		}
	}

}