package com.amity.socialcloud.sdk.core.data.analytics

import androidx.paging.PagingSource
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.model.core.analytics.AmityViewedType
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.entity.AnalyticsEventEntity
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

internal class AnalyticsLocalDataStore {

    fun saveAnalyticsEvents(analyticEvents: List<AnalyticsEventEntity>): Completable {
        return Completable.fromAction {
            UserDatabase.get().analyticsEventDao().save(analyticEvents)
        }
    }

    fun getAnalyticsEvents(
        userId: String,
        syncPriority: AnalyticsEventSyncPriority,
        limit: Int
    ): Single<List<AnalyticsEventEntity>> {
        return UserDatabase.get().analyticsEventDao().getAnalyticEvents(
            userId = userId,
            syncPriority = syncPriority.apiKey,
            limit = limit
        )
    }

    fun deleteAnalyticsEvents(analyticEvents: List<AnalyticsEventEntity>): Completable {
        return Completable.fromAction {
            UserDatabase.get().analyticsEventDao().delete(analyticEvents)
        }
    }

    fun deleteAllAnalyticsEvents(): Completable {
        return Completable.fromAction {
            UserDatabase.get().analyticsEventDao().deleteAll()
        }
    }

    fun deleteOldestEvent(): Completable {
        return Completable.fromAction {
            UserDatabase.get().analyticsEventDao().deleteOldestEvent()
        }
    }

    fun getAnalyticsEventsCount(): Single<Int> {
        return UserDatabase.get().analyticsEventDao().getAnalyticEventsCount()
    }

    fun getViewedUsersPagingSource(
        viewableItemType: AmityViewedType,
        viewableItemId: String
    ): PagingSource<Int, UserEntity> {
        return UserDatabase.get().viewedUsersPagingDao()
            .getViewedUsersPagingSource(viewableItemType, viewableItemId)
    }
}