package com.amity.socialcloud.sdk.core.data.file

import co.amity.rxupload.FileProperties
import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.model.core.file.AmityFileType
import com.amity.socialcloud.sdk.model.core.file.AmityRawFile
import com.ekoapp.ekosdk.internal.EkoFileEntity
import com.ekoapp.ekosdk.internal.mapper.AmityFilePropertiesMapper

class RawFileModelMapper : ModelMapper<EkoFileEntity, AmityRawFile>() {

    override fun map(entity: EkoFileEntity): AmityRawFile {
        val fileProps = AmityFilePropertiesMapper().map(entity)!!
        val publicFileType = getPublicFileType(entity, fileProps)
        return AmityRawFile(
            fileId = entity.fileId,
            fileType = publicFileType,
            filePath = entity.filePath,
            properties = fileProps
        )
    }

    private fun getPublicFileType(entity: EkoFileEntity, fileProps: FileProperties) : AmityFileType {
        var publicType = AmityFileType.enumOf(entity.getFileType())
        when(publicType) {
            AmityFileType.FILE -> {
                if(fileProps.mimeType.startsWith("audio", true)) {
                    publicType = AmityFileType.AUDIO
                }
            }
            AmityFileType.VIDEO -> {
                if(fileProps.mimeType.startsWith("image", true)) {
                    publicType = AmityFileType.IMAGE
                }
            }
            else -> {
                // do nothing
            }
        }
        return publicType
    }

}