package com.amity.socialcloud.sdk.core.data.notification.user

import com.amity.socialcloud.sdk.model.core.notification.AmityUserNotificationModule
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.EkoPushNotificationModuleDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoNotificationModuleRequestMapper
import com.ekoapp.ekosdk.internal.api.socket.request.NotificationSaveSettingsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class UserNotificationRemoteDataStore {

    fun getSetting(): Single<EkoPushNotificationModuleDto> {
        return AmityHttpClient.get(UserNotificationApi::class).flatMap {
            it.getSetting()
        }
    }

    fun saveSetting( isEnabled: Boolean,
                     moduleModifiers: List<AmityUserNotificationModule.MODIFIER>? = null): Single<JsonObject> {
        val request = NotificationSaveSettingsRequest.User(
            isEnabled,
            EkoNotificationModuleRequestMapper().map(moduleModifiers)
        )
        return AmityHttpClient.get(UserNotificationApi::class).flatMap {
            it.saveSetting(request)
        }
    }
}