package com.amity.socialcloud.sdk.core.data.notificationtray

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Query
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTrayItemEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Flowable
import org.joda.time.DateTime

@Dao
abstract class AmityNotificationTrayItemDao : EkoObjectDao<NotificationTrayItemEntity>() {

    // dummy update post
    @Query("UPDATE notificationTrayItem set notificationId = notificationId where notificationId = :notificationId")
    abstract fun updateNotificationItem(notificationId: String)

    @Query(
        "SELECT *" +
                " from notificationTrayItem" +
                " where notificationId = :notificationId"
    )
    abstract fun getByIdNowImpl(notificationId: String): NotificationTrayItemEntity?
    override fun getByIdNow(notificationId: String): NotificationTrayItemEntity? {
        return getByIdNowImpl(notificationId)
    }

    @Delete
    abstract override fun delete(notitray: NotificationTrayItemEntity)

    @Query("DELETE from notificationTrayItem")
    abstract override fun deleteAll()

    @Query(
        "SELECT *" +
                " from notificationTrayItem" +
                " where notificationId = :notificationItemId"
    )
    abstract fun observeNotificationTrayItemImpl(notificationItemId: String): Flowable<NotificationTrayItemEntity>
    fun observeNotificationTrayItem(notificationTrayItemId: String): Flowable<NotificationTrayItemEntity> {
        return observeNotificationTrayItemImpl(notificationTrayItemId)
    }


    @Query("UPDATE notificationTrayItem SET lastSeenAt = :lastSeenAt WHERE notificationId = :notificationId")
    abstract fun updateLastSeenAt(notificationId: String, lastSeenAt: DateTime): Int
    fun markAsSeen(
        notificationId: String,
        lastSeenAt: DateTime,
    ): Int {
        return updateLastSeenAt(notificationId, lastSeenAt)
    }
}