package com.amity.socialcloud.sdk.core.session.eventbus

import com.amity.socialcloud.sdk.core.session.model.SessionLifeCycle
import io.reactivex.rxjava3.core.BackpressureStrategy
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers
import io.reactivex.rxjava3.subjects.PublishSubject

class SessionLifeCycleEventBus {

    private val eventPublisher: PublishSubject<SessionLifeCycle> = PublishSubject.create()


    fun observe(): Flowable<SessionLifeCycle> {
        return eventPublisher.toFlowable(BackpressureStrategy.BUFFER)
            .distinctUntilChanged()
            .subscribeOn(Schedulers.io())
    }

    fun publish(sessionLifeCycle: SessionLifeCycle) {
        eventPublisher.onNext(sessionLifeCycle)
    }

}