package com.amity.socialcloud.sdk.core.session.transformer

import com.amity.socialcloud.sdk.core.session.model.SessionLifeCycle
import com.amity.socialcloud.sdk.core.session.model.SessionState

object SessionLifeCycleTransformer {

    fun transform(currentSessionState: SessionState): SessionLifeCycle? {
        return when (currentSessionState) {
            is SessionState.TokenExpired -> {
                SessionLifeCycle.HandleTokenExpire
            }
            is SessionState.Terminated -> {
                SessionLifeCycle.Destroy
            }
            is SessionState.NotLoggedIn -> {
                SessionLifeCycle.Destroy
            }
            else -> null
        }
    }
}